<?php include 'partials/html.php' ?>

<head>
    <?php
    $title = "Customers";
    include 'partials/title-meta.php' ?>

    <?php include 'partials/head-css.php' ?>
</head>

<body>
    <!-- Top Bar Start -->
    <?php include 'partials/topbar.php' ?>
    <!-- Top Bar End -->
    <!-- leftbar-tab-menu -->
    <?php include 'partials/startbar.php' ?>
    <!-- end leftbar-tab-menu-->

    <div class="page-wrapper">
        <!-- Page Content-->
        <div class="page-content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="page-title-box d-md-flex justify-content-md-between align-items-center">
                            <h4 class="page-title">Customers</h4>
                            <div class="">
                                <ol class="breadcrumb mb-0">
                                    <li class="breadcrumb-item"><a href="#">Dastone</a>
                                    </li><!--end nav-item-->
                                    <li class="breadcrumb-item"><a href="#">Analytics</a>
                                    </li><!--end nav-item-->
                                    <li class="breadcrumb-item active">Customers</li>
                                </ol>
                            </div>
                        </div><!--end page-title-box-->
                    </div><!--end col-->
                </div><!--end row-->
                <div class="row">
                    <div class="col-md-6 col-lg-3">
                        <div class="card">
                            <div class="card-body">
                                <div class="row d-flex justify-content-center">
                                    <div class="col-9">
                                        <p class="text-dark mb-0 fw-semibold">Twitter</p>
                                        <h3 class="mt-2 mb-0 fs-20">2215 <span class="fs-13 text-muted fw-medium">Click</span> </h3>
                                    </div><!--end col-->
                                    <div class="col-3 align-self-center">
                                        <div class="d-flex justify-content-center align-items-center thumb-lg bg-soft-secondary rounded-circle mx-auto">
                                            <i class="icofont-twitter  align-self-center mb-0 text-secondary"></i>
                                        </div>
                                    </div><!--end col-->
                                </div><!--end row-->
                            </div><!--end card-body-->
                        </div><!--end card-->
                    </div><!--end col-->
                    <div class="col-md-6 col-lg-3">
                        <div class="card">
                            <div class="card-body">
                                <div class="row d-flex justify-content-center">
                                    <div class="col-9">
                                        <p class="text-dark mb-0 fw-semibold">Google</p>
                                        <h3 class="mt-2 mb-0 fs-20">3652 <span class="fs-13 text-muted fw-medium">Click</span> </h3>
                                    </div><!--end col-->
                                    <div class="col-3 align-self-center">
                                        <div class="d-flex justify-content-center align-items-center thumb-lg bg-soft-danger rounded-circle mx-auto">
                                            <i class="icofont-google-plus align-self-center mb-0 text-danger"></i>
                                        </div>
                                    </div><!--end col-->
                                </div><!--end row-->
                            </div><!--end card-body-->
                        </div><!--end card-->
                    </div><!--end col-->
                    <div class="col-md-6 col-lg-3">
                        <div class="card">
                            <div class="card-body">
                                <div class="row d-flex justify-content-center">
                                    <div class="col-9">
                                        <p class="text-dark mb-0 fw-semibold">Instagram</p>
                                        <h3 class="mt-2 mb-0 fs-20">2548 <span class="fs-13 text-muted fw-medium">Click</span> </h3>
                                    </div><!--end col-->
                                    <div class="col-3 align-self-center">
                                        <div class="d-flex justify-content-center align-items-center thumb-lg bg-soft-warning rounded-circle mx-auto">
                                            <i class="icofont-instagram align-self-center mb-0 text-warning"></i>
                                        </div>
                                    </div><!--end col-->
                                </div><!--end row-->
                            </div><!--end card-body-->
                        </div><!--end card-->
                    </div><!--end col-->
                    <div class="col-md-6 col-lg-3">
                        <div class="card">
                            <div class="card-body">
                                <div class="row d-flex justify-content-center">
                                    <div class="col-9">
                                        <p class="text-dark mb-0 fw-semibold">Facebook</p>
                                        <h3 class="mt-2 mb-0 fs-20">5242 <span class="fs-13 text-muted fw-medium">Click</span> </h3>
                                    </div><!--end col-->
                                    <div class="col-3 align-self-center">
                                        <div class="d-flex justify-content-center align-items-center thumb-lg bg-soft-blue rounded-circle mx-auto">
                                            <i class="icofont-facebook align-self-center mb-0 text-blue"></i>
                                        </div>
                                    </div><!--end col-->
                                </div><!--end row-->
                            </div><!--end card-body-->
                        </div><!--end card-->
                    </div> <!--end col-->
                </div><!--end row-->
                <div class="row">
                    <div class="col-md-12 col-lg-8">
                        <div class="card">
                            <div class="card-header">
                                <div class="row align-items-center">
                                    <div class="col">
                                        <h4 class="card-title">Customers Growth</h4>
                                    </div><!--end col-->
                                    <div class="col-auto">
                                        <div class="dropdown">
                                            <a href="#" class="btn btn-sm btn-outline-light dropdown-toggle" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                This Year<i class="las la-angle-down ms-1"></i>
                                            </a>
                                            <div class="dropdown-menu dropdown-menu-end">
                                                <a class="dropdown-item" href="#">Today</a>
                                                <a class="dropdown-item" href="#">Last Week</a>
                                                <a class="dropdown-item" href="#">Last Month</a>
                                                <a class="dropdown-item" href="#">This Year</a>
                                            </div>
                                        </div>
                                    </div><!--end col-->
                                </div> <!--end row-->
                            </div><!--end card-header-->
                            <div class="card-body">
                                <div id="customers-line" class="apex-charts mb-3"></div>
                            </div><!--end card-body-->
                        </div><!--end card-->
                    </div> <!--end col-->
                    <div class="col-md-12 col-lg-4">
                        <div class="row g-3">
                            <div class="col-md-6 col-lg-6">
                                <div class="card mb-3 mb-lg-0">
                                    <div class="card-body text-center">
                                        <span class="fs-18 fw-semibold">38,321</span>
                                        <h6 class="text-uppercase text-muted my-2 m-0">Total Customers</h6>
                                        <div class="d-flex align-items-center">
                                            <div class="progress bg-primary-subtle w-100" style="height:5px;" role="progressbar" aria-label="Success example" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100">
                                                <div class="progress-bar bg-primary" style="width: 65%"></div>
                                            </div>
                                            <small class="flex-shrink-1 ms-1">65%</small>
                                        </div>
                                    </div><!--end card-body-->
                                </div> <!--end card-body-->
                            </div><!--end col-->
                            <div class="col-md-6 col-lg-6">
                                <div class="card mb-3 mb-lg-0">
                                    <div class="card-body text-center">
                                        <span class="fs-18 fw-semibold">946</span>
                                        <h6 class="text-uppercase text-muted my-2 m-0">New Customers</h6>
                                        <div class="d-flex align-items-center">
                                            <div class="progress bg-primary-subtle w-100" style="height:5px;" role="progressbar" aria-label="Success example" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100">
                                                <div class="progress-bar bg-primary" style="width: 38%"></div>
                                            </div>
                                            <small class="flex-shrink-1 ms-1">38%</small>
                                        </div>
                                    </div><!--end card-body-->
                                </div> <!--end card-body-->
                            </div><!--end col-->

                            <div class="col-md-6 col-lg-6">
                                <div class="card mb-3 mb-lg-0">
                                    <div class="card-body text-center">
                                        <span class="fs-18 fw-semibold">70.8%</span>
                                        <h6 class="text-uppercase text-muted my-2 m-0">Returning Customers</h6>
                                        <div class="d-flex align-items-center">
                                            <div class="progress bg-primary-subtle w-100" style="height:5px;" role="progressbar" aria-label="Success example" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100">
                                                <div class="progress-bar bg-primary" style="width: 85%"></div>
                                            </div>
                                            <small class="flex-shrink-1 ms-1">85%</small>
                                        </div>
                                    </div><!--end card-body-->
                                </div> <!--end card-->
                            </div><!--end col-->
                            <div class="col-md-6 col-lg-6">
                                <div class="card mb-3 mb-lg-0">
                                    <div class="card-body text-center">
                                        <span class="fs-18 fw-semibold">1.5%</span>
                                        <h6 class="text-uppercase text-muted my-2 m-0">Bounce Rate</h6>
                                        <div class="d-flex align-items-center">
                                            <div class="progress bg-primary-subtle w-100" style="height:5px;" role="progressbar" aria-label="Success example" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100">
                                                <div class="progress-bar bg-primary" style="width: 40%"></div>
                                            </div>
                                            <small class="flex-shrink-1 ms-1">40%</small>
                                        </div>
                                    </div><!--end card-body-->
                                </div> <!--end card-body-->
                            </div><!--end col-->
                        </div><!--end row-->
                    </div> <!--end col-->
                </div><!--end row-->

                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <div class="row align-items-center">
                                    <div class="col">
                                        <h4 class="card-title">Customers Details</h4>
                                    </div><!--end col-->
                                </div> <!--end row-->
                            </div><!--end card-header-->
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table class="table mb-0">
                                        <thead class="table-light">
                                            <tr>
                                                <th>Name</th>
                                                <th>Ext.</th>
                                                <th>City</th>
                                                <th data-type="date" data-format="YYYY/DD/MM">Start Date</th>
                                                <th>Completion</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td class="d-flex align-items-center">
                                                    <img src="assets/images/users/avatar-1.jpg" alt="" class="thumb-md rounded-circle me-1">
                                                    Unity Pugh
                                                </td>
                                                <td>9958</td>
                                                <td>Curicó</td>
                                                <td>2005/02/11</td>
                                                <td>37%</td>
                                            </tr>
                                            <tr>
                                                <td class="d-flex align-items-center">
                                                    <img src="assets/images/users/avatar-2.jpg" alt="" class="thumb-md rounded-circle me-1">
                                                    Theodore Duran
                                                </td>
                                                <td>8971</td>
                                                <td>Dhanbad</td>
                                                <td>1999/04/07</td>
                                                <td>97%</td>
                                            </tr>
                                            <tr>
                                                <td class="d-flex align-items-center">
                                                    <img src="assets/images/users/avatar-3.jpg" alt="" class="thumb-md rounded-circle me-1">
                                                    Kylie Bishop
                                                </td>
                                                <td>3147</td>
                                                <td>Norman</td>
                                                <td>2005/09/08</td>
                                                <td>63%</td>
                                            </tr>
                                            <tr>
                                                <td class="d-flex align-items-center">
                                                    <img src="assets/images/users/avatar-4.jpg" alt="" class="thumb-md rounded-circle me-1">
                                                    Willow Gilliam
                                                </td>
                                                <td>3497</td>
                                                <td>Amqui</td>
                                                <td>2009/29/11</td>
                                                <td>30%</td>
                                            </tr>
                                            <tr>
                                                <td class="d-flex align-items-center">
                                                    <img src="assets/images/users/avatar-5.jpg" alt="" class="thumb-md rounded-circle me-1">
                                                    Blossom Dickerson
                                                </td>
                                                <td>5018</td>
                                                <td>Kempten</td>
                                                <td>2006/11/09</td>
                                                <td>17%</td>
                                            </tr>
                                            <tr>
                                                <td class="d-flex align-items-center">
                                                    <img src="assets/images/users/avatar-3.jpg" alt="" class="thumb-md rounded-circle me-1">
                                                    Elliott Snyder
                                                </td>
                                                <td>3925</td>
                                                <td>Enines</td>
                                                <td>2006/03/08</td>
                                                <td>57%</td>
                                            </tr>
                                            <tr>
                                                <td class="d-flex align-items-center">
                                                    <img src="assets/images/users/avatar-1.jpg" alt="" class="thumb-md rounded-circle me-1">
                                                    Castor Pugh
                                                </td>
                                                <td>9488</td>
                                                <td>Neath</td>
                                                <td>2014/23/12</td>
                                                <td>93%</td>
                                            </tr>
                                            <tr>
                                                <td class="d-flex align-items-center">
                                                    <img src="assets/images/users/avatar-2.jpg" alt="" class="thumb-md rounded-circle me-1">
                                                    Pearl Carlson
                                                </td>
                                                <td>6231</td>
                                                <td>Cobourg</td>
                                                <td>2014/31/08</td>
                                                <td>100%</td>
                                            </tr>
                                            <tr>
                                                <td class="d-flex align-items-center">
                                                    <img src="assets/images/users/avatar-3.jpg" alt="" class="thumb-md rounded-circle me-1">
                                                    Deirdre Bridges
                                                </td>
                                                <td>1579</td>
                                                <td>Eberswalde-Finow</td>
                                                <td>2014/26/08</td>
                                                <td>44%</td>
                                            </tr>
                                            <tr>
                                                <td class="d-flex align-items-center">
                                                    <img src="assets/images/users/avatar-4.jpg" alt="" class="thumb-md rounded-circle me-1">
                                                    Daniel Baldwin
                                                </td>
                                                <td>6095</td>
                                                <td>Moircy</td>
                                                <td>2000/11/01</td>
                                                <td>33%</td>
                                            </tr>
                                            <tr>
                                                <td class="d-flex align-items-center">
                                                    <img src="assets/images/users/avatar-5.jpg" alt="" class="thumb-md rounded-circle me-1">
                                                    Pearl Carlson
                                                </td>
                                                <td>6231</td>
                                                <td>Cobourg</td>
                                                <td>2014/31/08</td>
                                                <td>100%</td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div> <!-- end col -->
                </div> <!-- end row -->
            </div><!-- container -->

            <!--Start Rightbar-->
            <?php include 'partials/endbar.php' ?>
            <!--end Rightbar-->
            <!--Start Footer-->
            <?php include 'partials/footer.php' ?>
            <!--end footer-->
        </div>
        <!-- end page content -->
    </div>
    <!-- end page-wrapper -->

    <!-- Javascript  -->
    <!-- vendor js -->
    <?php include 'partials/vendorjs.php' ?>
    <script src="assets/libs/apexcharts/apexcharts.min.js"></script>
    <script src="assets/js/pages/analytics-customers.init.js"></script>
    <script src="assets/js/app.js"></script>
</body>
<!--end body-->

</html>