<?php include 'partials/html.php' ?>

<head>
    <?php
    $title = "Reports";
    include 'partials/title-meta.php' ?>

    <link rel="stylesheet" href="assets/libs/jsvectormap/jsvectormap.min.css">
    <?php include 'partials/head-css.php' ?>
</head>

<body>
    <!-- Top Bar Start -->
    <?php include 'partials/topbar.php' ?>
    <!-- Top Bar End -->
    <!-- leftbar-tab-menu -->
    <?php include 'partials/startbar.php' ?>
    <!-- end leftbar-tab-menu-->

    <div class="page-wrapper">
        <!-- Page Content-->
        <div class="page-content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="page-title-box d-md-flex justify-content-md-between align-items-center">
                            <h4 class="page-title">Reports</h4>
                            <div class="">
                                <ol class="breadcrumb mb-0">
                                    <li class="breadcrumb-item"><a href="#">Dastone</a>
                                    </li><!--end nav-item-->
                                    <li class="breadcrumb-item"><a href="#">Analytics</a>
                                    </li><!--end nav-item-->
                                    <li class="breadcrumb-item active">Reports</li>
                                </ol>
                            </div>
                        </div><!--end page-title-box-->
                    </div><!--end col-->
                </div><!--end row-->
                <div class="row">
                    <div class="col-md-12 col-lg-7">
                        <div class="card">
                            <div class="card-header">
                                <div class="row align-items-center">
                                    <div class="col">
                                        <h4 class="card-title">Metrics</h4>
                                    </div><!--end col-->
                                    <div class="col-auto">
                                        <div class="dropdown">
                                            <a href="#" class="btn btn-sm btn-outline-light dropdown-toggle" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                This Year<i class="las la-angle-down ms-1"></i>
                                            </a>
                                            <div class="dropdown-menu dropdown-menu-end">
                                                <a class="dropdown-item" href="#">Today</a>
                                                <a class="dropdown-item" href="#">Last Week</a>
                                                <a class="dropdown-item" href="#">Last Month</a>
                                                <a class="dropdown-item" href="#">This Year</a>
                                            </div>
                                        </div>
                                    </div><!--end col-->
                                </div> <!--end row-->
                            </div><!--end card-header-->
                            <div class="card-body">
                                <div id="reports-bar" class="apex-charts pill-bar"></div>
                            </div><!--end card-body-->
                        </div><!--end card-->
                    </div> <!--end col-->
                    <div class="col-md-12 col-lg-5">
                        <div class="card">
                            <div class="card-header">
                                <div class="row align-items-center">
                                    <div class="col">
                                        <h4 class="card-title">Top Country</h4>
                                    </div><!--end col-->
                                </div> <!--end row-->
                            </div><!--end card-header-->
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="d-flex align-items-center py-3">
                                            <img src="assets/images/flags/us_flag.jpg" class="thumb-sm align-self-center rounded-circle" alt="...">
                                            <div class="flex-grow-1 ms-2">
                                                <h5 class="m-0">35,365</h5>
                                                <p class="text-muted mb-0">USA</p>
                                            </div><!--end media-body-->
                                        </div><!--end media-->
                                    </div><!--end col-->
                                    <div class="col-md-4">
                                        <div class="d-flex align-items-center py-3">
                                            <img src="assets/images/flags/germany_flag.jpg" class="thumb-sm align-self-center rounded-circle" alt="...">
                                            <div class="flex-grow-1 ms-2">
                                                <h5 class="m-0">24,865</h5>
                                                <p class="text-muted mb-0">Germany</p>
                                            </div><!--end media-body-->
                                        </div><!--end media-->
                                    </div><!--end col-->
                                    <div class="col-md-4">
                                        <div class="d-flex align-items-center py-3">
                                            <img src="assets/images/flags/spain_flag.jpg" class="thumb-sm align-self-center rounded-circle" alt="...">
                                            <div class="flex-grow-1 ms-2">
                                                <h5 class="m-0">18,369</h5>
                                                <p class="text-muted mb-0">Spain</p>
                                            </div><!--end media-body-->
                                        </div><!--end media-->
                                    </div><!--end col-->
                                </div> <!--end row-->
                                <div id="map_2" class style="height:300px"></div>
                            </div><!--end card-body-->
                        </div><!--end card-->
                    </div> <!--end col-->
                </div><!--end row-->
                <div class="row">
                    <div class="col-lg-6">
                        <div class="card">
                            <div class="card-header">
                                <div class="row align-items-center">
                                    <div class="col">
                                        <h4 class="card-title">Visits Details</h4>
                                    </div><!--end col-->
                                </div> <!--end row-->
                            </div><!--end card-header-->
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table class="table mb-0">
                                        <thead class="table-light">
                                            <tr>
                                                <th>URL</th>
                                                <th class="text-end">Views</th>
                                                <th class="text-end">Uniques</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td>htpps:/</td>
                                                <td class="text-end">9.2k</td>
                                                <td class="text-end">7.9k</td>
                                            </tr>
                                            <tr>
                                                <td>.com/dashboard</td>
                                                <td class="text-end">7.7k</td>
                                                <td class="text-end">6.2k</td>
                                            </tr>
                                            <tr>
                                                <td>.com/ecommerce-index</td>
                                                <td class="text-end">6.8k</td>
                                                <td class="text-end">5.5k</td>
                                            </tr>
                                            <tr>
                                                <td>.com/apps/projects-overview</td>
                                                <td class="text-end">5k</td>
                                                <td class="text-end">4.9k</td>
                                            </tr>
                                            <tr>
                                                <td>.com/blog/crypto/exchange</td>
                                                <td class="text-end">4.3k</td>
                                                <td class="text-end">3.3k</td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div> <!-- end col -->
                    <div class="col-lg-6">
                        <div class="card">
                            <div class="card-header">
                                <div class="row align-items-center">
                                    <div class="col">
                                        <h4 class="card-title">By Social Media</h4>
                                    </div><!--end col-->
                                </div> <!--end row-->
                            </div><!--end card-header-->
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table class="table mb-0">
                                        <thead class="table-light">
                                            <tr>
                                                <th>Source</th>
                                                <th class="text-end">Views</th>
                                                <th class="text-end">Uniques</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td>Twitter</td>
                                                <td class="text-end">9.2k</td>
                                                <td class="text-end">7.9k</td>
                                            </tr>
                                            <tr>
                                                <td>Facebook</td>
                                                <td class="text-end">7.7k</td>
                                                <td class="text-end">6.2k</td>
                                            </tr>
                                            <tr>
                                                <td>Instagram</td>
                                                <td class="text-end">6.8k</td>
                                                <td class="text-end">5.5k</td>
                                            </tr>
                                            <tr>
                                                <td>LinkedIn</td>
                                                <td class="text-end">5k</td>
                                                <td class="text-end">4.9k</td>
                                            </tr>
                                            <tr>
                                                <td>WhatsApp</td>
                                                <td class="text-end">4.3k</td>
                                                <td class="text-end">3.3k</td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div> <!-- end col -->
                </div> <!-- end row -->
            </div><!-- container -->

            <!--Start Rightbar-->
            <?php include 'partials/endbar.php' ?>
            <!--end Rightbar-->
            <!--Start Footer-->
            <?php include 'partials/footer.php' ?>
            <!--end footer-->
        </div>
        <!-- end page content -->
    </div>
    <!-- end page-wrapper -->

    <!-- Javascript  -->
    <!-- vendor js -->
    <?php include 'partials/vendorjs.php' ?>
    <script src="assets/libs/apexcharts/apexcharts.min.js"></script>
    <script src="assets/libs/jsvectormap/jsvectormap.min.js"></script>
    <script src="assets/libs/jsvectormap/maps/world.js"></script>
    <script src="assets/js/pages/analytics-reports.init.js"></script>
    <script src="assets/js/app.js"></script>
</body>
<!--end body-->

</html>